<?php
date_default_timezone_set('America/Santiago');
$DIAS    = array("","Lunes","Martes","Miercoles","Jueves","Viernes","Sábado","Domingo");
$DIAS_ENG= array("","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday");
$MESES    = array("","Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
$MESES_CORTO= array("","Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic");
$MESES_ENG= array("","January","February","March","April","May","June","July","August","September","October","November","December");

setlocale(LC_TIME, 'spanish'); 
function dias_diferencia($fecha1, $fecha2){
	
$datetime1 = date_create(fecha($fecha1, $formato='sql'));
$datetime2 = date_create(fecha($fecha2, $formato='sql'));
$interval = date_diff($datetime1, $datetime2);

return $interval->days;	
	
}
function es_fecha($valor){
	if(strpos($valor, '-'))$separador_fecha="-";
	if(strpos($valor, '/'))$separador_fecha="/";
	if($separador_fecha)$aux=explode($separador_fecha, $valor);
	if($aux[1]=='00')return false;
	elseif(count($aux)>=3) return true;
	else return false;
	
}
function rango_fechas($fecha, $dias){
$fecha = fecha($fecha, 'Y-m-d' );	

if(!is_numeric($dias))$dias=dias_diferencia($fecha, $dias);
for($i=0;$i<=$dias; $i++):
$nuevafecha = strtotime ( '+'.$i.' day' , strtotime ( $fecha ) ) ;
$rango_fechas[]= date ( 'd/m/Y' , $nuevafecha );

endfor;	
	return $rango_fechas;
}
function fecha($fecha, $formato='chile'){
	
	
	if ($fecha=='hoy')$fecha=date("Y-m-d H:i:s");
if($fecha):
	if(strpos($fecha, '-'))$separador_fecha="-";
	if(strpos($fecha, '/'))$separador_fecha="/";
	
     list($dia,$mes,$año)=explode($separador_fecha , $fecha);
	if(strpos($año, ':')){ list($año,$hora)=explode(' ' , $año); }
	if($dia>32) $fecha=$fecha;
	else  $fecha=$año.'-'.$mes.'-'.$dia.' '.$hora;	//lo convertimos en una fecha para modificar
	
	if($formato=='chile'){
		
	if($hora)	 return date("d/m/Y H:i", strtotime($fecha)); 
	else return date("d/m/Y", strtotime($fecha));  
		 
	}
	elseif($formato=='sql')return date("Y-m-d H:i:s", strtotime($fecha)); 
	elseif($formato=='sql_fecha')return date("Y-m-d", strtotime($fecha)); 
	elseif($formato=='sql_corto')return date("Y-m-d", strtotime($fecha)); 
	elseif($formato=='dia')return  (date("d", strtotime($fecha))); 
	elseif($formato=='mes')return  (date("m", strtotime($fecha))); 
	elseif($formato=='MES')return  fecha_espa(date("F Y", strtotime($fecha))); 
	elseif($formato=='anho')return  (date("Y", strtotime($fecha))); 
	elseif($formato=='corto')return date("d/m/Y", strtotime($fecha)); 
	elseif($formato=='completo')return  fecha_espa(date("j \d\\e F \d\\e Y", strtotime($fecha))); 
	elseif(si_contiene($formato, 'F') or si_contiene($formato,'D') or si_contiene($formato,'l') ) return  fecha_espa(date($formato, strtotime($fecha)));
	else return date($formato, strtotime($fecha)); 
 endif;
}
function AHORA(){	
return date("Y-m-d H:i:s");
}
function anhoACTUAL(){
	return date("Y");
	
}
function mesACTUAL($dif=0){
	if($dif==0)return date("n");
	else{
		$hoy=AHORA();
		$aux=fecha(sumar_meses( $hoy,$dif), "n" );
		return  $aux;
		 
	}
	
}
function fecha_espa($fecha){
	global $DIAS,$DIAS_ENG,$MESES,$MESES_ENG;
	$fecha= str_replace($MESES_ENG, $MESES, $fecha);
	$fecha= str_replace($DIAS_ENG, $DIAS , $fecha);
	return $fecha;
}
function hora($fecha){
return date("H:i",strtotime($fecha));	
	
}
function cuando($fecha, $formato=''){
$texto='Nunca';	
if(isset($fecha)):
$hora_minutos = date("H:i",strtotime($fecha));
$dias=(time()-strtotime($fecha));

switch ($dias) {   
    case 0:
        $texto= "Hoy, A las $hora_minutos";
    break;
    case 1:
        $texto="Ayer, A las $hora_minutos"; 
    break;
    default:
	   if($formato=='full')$texto=  fecha_espa(date("l j \d\\e F \d\\e Y \a \ \l\a\s H:i", strtotime($fecha)));
	    if($formato=='')$texto=  fecha_espa(date("l j \d\\e F \d\\e Y ", strtotime($fecha)));
    
}
endif;
 return $texto;
}
function ultimo_dia_mes($fecha,$formato='corto'){
	$month=fecha($fecha,'Y-m');
	$aux = date('Y-m-d', strtotime("{$month} + 1 month"));
$last_day = date('Y-m-d', strtotime("{$aux} - 1 day"));
return fecha($last_day,$formato);
}
function sumar_meses($fecha,$meses)
{   
  $fecha =fecha($fecha, 'sql' );

 	
    $nuevafecha = strtotime ( $meses.' month' , strtotime ( $fecha) ) ;
	
	 $retorno=date ( 'Y-m-d H:i:s' , $nuevafecha );
	
     return $retorno;
}

function sumar_dias($fecha,$dias)
{   
  $fecha =fecha($fecha, 'sql' );
 
    $nuevafecha = strtotime ( '+'.$dias.' day' , strtotime ( $fecha) ) ;
	  
     return date ( 'd/m/Y' , $nuevafecha);    
}
function restar_dias($fecha,$dias)
{   
  $fecha =fecha($fecha, 'sql' );
 
    $nuevafecha = strtotime ( '-'.$dias.' day' , strtotime ( $fecha) ) ;
	  
     return date ( 'd/m/Y' , $nuevafecha);    
}
function getUltimoDiaMes($fecha) {
	$Mes=fecha($fecha, $formato="m" );
	$Anio=fecha($fecha, $formato="Y" );
  return date("d-m-Y",(mktime(0,0,0,$Mes+1,1,$Anio)-1));
}


function HOY($formato="%A %#d de %B del %Y"){
	
echo strftime($formato);
}
function HOY_SQL(){
	
	return date("Y-m-d H:i:s");
}
function convertir_mes($mes){
	global $MESES;
$clave = array_search($mes, $MESES);
return  $clave;
}
function convertir_dia($dia){
	global $DIAS;
$clave = array_search($dia,$DIAS);
return  $clave;
}
function MES($fecha){
	global $MESES;
	$retorno=fecha($fecha, $formato="n" );
	return $MESES[$retorno];
}
function SEMANA($fecha, $devuelve=''){
	$mes=fecha($fecha, $formato="m" );
	if($devuelve=='')$retorno=fecha($fecha, $formato="W" );
	if($devuelve=='incial')$retorno=fecha('01-'.$mes.'-2014', $formato="W" );
	return $retorno;
}
function fecha_semana ($semana){
	$semana_actual=date('W');
	$dias=($semana-$semana_actual)*7;
	$fecha_semana=sumar_dias(date("d-m-Y"),$dias);
	return $fecha_semana;
}
function calendario_semanal($fecha){
$dia_actual=fecha($fecha, $formato="N" );
$Fecha_Menu= array(
	'fecha'=>$fecha,
	'fecha_mysql'=>fecha($fecha, $formato="Y-m-d" ),
	'dia'=>fecha($fecha, $formato="d" ),
	'dia_semana'=>$dia_actual,
	'mes'=>fecha($fecha, $formato="n" ),
	'Mes' =>MES($fecha),
	'Semana'=>SEMANA($fecha),
	'Semana_incial'=>SEMANA($fecha,'incial'),
	'Semana_final'=>SEMANA(getUltimoDiaMes($fecha)),
	'Lunes'=>fecha(sumar_dias($fecha,1-$dia_actual), $formato="d" ),
	'Martes'=>fecha(sumar_dias($fecha,2-$dia_actual), $formato="d" ),
	'Miercoles'=>fecha(sumar_dias($fecha,3-$dia_actual), $formato="d" ),
	'Jueves'=>fecha(sumar_dias($fecha,4-$dia_actual), $formato="d" ),
	'Viernes'=>fecha(sumar_dias($fecha,5-$dia_actual), $formato="d" ),
	'Sabado'=>fecha(sumar_dias($fecha,6-$dia_actual), $formato="d" ),
	'Domingo'=>fecha(sumar_dias($fecha,7-$dia_actual), $formato="d" ),
);
if($Fecha_Menu['mes']==12){
	$Fecha_Menu['Semana_final']='53';
if($Fecha_Menu['Semana']==01)$Fecha_Menu['Semana']='53';
}
return $Fecha_Menu;
}
function Sig_mes($Fecha_Menu, $url=''){
	global $MESES;
	if ( $Fecha_Menu['mes'] < 12)
	echo ' <a href="'.URL.$url.'Mes/'.$MESES[($Fecha_Menu['mes']+1)].'"> <img src="'.URL.'img/sig.png" width="10" height="10" /></a> ';
}
function Ant_mes($Fecha_Menu, $url=''){
	global $MESES;
	if ( $Fecha_Menu['mes'] > 1)
	echo ' <a href="'.URL.$url.'Mes/'.$MESES[($Fecha_Menu['mes']-1)].'"> <img src="'.URL.'img/atras.png" width="10" height="10" /></a> ';
}
global $MESES;